<?LassoScript

// a custom tag to get the real server name from the headers from greg willits
// use because the [server_name] tag sometimes has problems with multiple virtual hosts on the same IP
// Example: [getServerName]

if: !(lasso_tagexists:'getServerName');
define_tag:'getServerName';
local:'host'=((string_findregexp:
		(client_headers),
		-find='(.*)HOST:(.*)',
		-ignorecase)->get:3);
	local:'subHost'=(#host->(split:'.')->(get:2));
	#host->trim;
	#subHost->trim;
return: (string: #subHost);
/define_tag;
/if;



// to prevent a malicious user from doing bad things to your site via a link on a page on their site back to your site
// this protects against malicious site Cross-Site Request Forgery Attack (CSRF)
// i.e. a server with a different name that the server this file resides on
if: (string: (referrer_URL)) != ''  &&  !(string: (referrer_URL))->(Contains: (getServerName));
'<br />Bad Hacker!' ;
abort;
/if;

include: 'fbx_LassoFusebox3.inc';

?>